/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.parser.gringo.BlockComment;
import aspmodificator.parser.gringo.ConstTerm;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import java.util.ArrayList;

public class MathTerm
extends Term {
    public static final String DIV = "/";
    public static final String MOD = "\\";
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    public static final String POW = "**";
    public static final String MULT = "*";
    public static final String ABS = "#abs";
    public static final String AND = "&";
    public static final String XOR = "^";
    public static final String BNOT = "~";
    public static final String SUPREMUM = "SUPREMUM";
    public static final String INFIMUM = "INFIMUM";
    public static final String OR = null;

    public static Term CreateNewMinusOne() {
        return new ConstTerm(-1);
    }

    public static Term CreateNewOne() {
        return new ConstTerm(1);
    }

    public static Term CreateNewZero() {
        return new ConstTerm(0);
    }

    protected MathTerm() {
    }

    public MathTerm(String operant, Literal a) {
        super(operant);
        ArrayList<Literal> tmpList = new ArrayList<Literal>();
        tmpList.add(a);
        this.setTerms(tmpList);
    }

    public MathTerm(String operant, Literal a, int lineNo) {
        super(operant, lineNo);
        ArrayList<Literal> tmpList = new ArrayList<Literal>();
        tmpList.add(a);
        this.setTerms(tmpList);
    }

    public MathTerm(String operant, Literal a, Literal b) {
        super(operant);
        ArrayList<Literal> tmpList = new ArrayList<Literal>();
        tmpList.add(a);
        tmpList.add(b);
        this.setTerms(tmpList);
    }

    public MathTerm(String operant, Literal a, Literal b, int lineNo) {
        super(operant, lineNo);
        ArrayList<Literal> tmpList = new ArrayList<Literal>();
        tmpList.add(a);
        tmpList.add(b);
        this.setTerms(tmpList);
    }

    private boolean hashHigherBinding(String identifier, Literal literal) {
        if (literal == null) {
            return false;
        }
        if (literal.getTerms() == null || literal.getTerms().size() <= 1) {
            return false;
        }
        if (!MathTerm.class.isAssignableFrom(literal.getClass())) {
            return false;
        }
        MathTerm m2 = (MathTerm)literal;
        if ((identifier.equals(MULT) || identifier.equals(DIV)) && (m2.identifier.equals(PLUS) || m2.identifier.equals(MINUS))) {
            return true;
        }
        return identifier.equals(POW) && (m2.identifier.equals(PLUS) || m2.identifier.equals(MINUS) || identifier.equals(MULT) || identifier.equals(DIV));
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.precedingComments != null && this.precedingComments.size() > 0) {
            for (BlockComment bc : this.precedingComments) {
                sb.append(bc.getText());
            }
        }
        if (this.identifier.equals(MINUS) && this.terms != null && this.terms.size() == 2 && ((Literal)this.terms.get(0)).toString().equals("0")) {
            sb.append(this.identifier);
            sb.append(((Literal)this.terms.get(1)).toString());
        } else if (this.terms != null && this.terms.size() == 2) {
            if (this.hashHigherBinding(this.identifier, (Literal)this.terms.get(0))) {
                sb.append("(");
                sb.append(((Literal)this.terms.get(0)).toString());
                sb.append(")");
            } else {
                sb.append(((Literal)this.terms.get(0)).toString());
            }
            sb.append(this.identifier);
            if (this.hashHigherBinding(this.identifier, (Literal)this.terms.get(1))) {
                sb.append("(");
                sb.append(((Literal)this.terms.get(1)).toString());
                sb.append(")");
            } else {
                sb.append(((Literal)this.terms.get(1)).toString());
            }
        } else if (this.terms != null && this.terms.size() == 1) {
            sb.append(this.identifier);
            sb.append("(");
            sb.append(((Literal)this.terms.get(0)).toString());
            sb.append(")");
        } else {
            sb.append(this.identifier);
        }
        if (this.succeedingComments != null && this.succeedingComments.size() > 0) {
            for (BlockComment bc : this.succeedingComments) {
                sb.append(bc.getText());
            }
        }
        return sb.toString();
    }
}

