/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Predicate;
import aspmodificator.parser.gringo.Signed;
import java.util.ArrayList;
import java.util.List;

public class MetaStatement
extends LineBase {
    public static final String SHOW = "#show";
    public static final String HIDE = "#hide";
    protected String token;
    private Predicate predicate;
    private List<Literal> literalList;
    private Signed id;
    private Integer number;

    public MetaStatement(String s) {
        this.token = s;
    }

    public MetaStatement(String s, int lineNo) {
        this.token = s;
        this.startLineNo = lineNo;
    }

    public MetaStatement(String tok, Predicate pred, List<Literal> list) {
        this.token = tok;
        this.predicate = pred;
        this.literalList = list;
    }

    public MetaStatement(String tok, Predicate pred, List<Literal> list, int lineNo) {
        this.token = tok;
        this.predicate = pred;
        this.literalList = list;
        this.startLineNo = lineNo;
    }

    public MetaStatement(String tok, Signed id, Integer num) {
        this.token = tok;
        this.id = id;
        this.number = num;
    }

    public MetaStatement(String tok, Signed id, Integer num, int lineNo) {
        this.token = tok;
        this.id = id;
        this.number = num;
        this.startLineNo = lineNo;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.id != null) {
            return new MetaStatement(this.token, this.id, this.number);
        }
        if (this.predicate != null) {
            ArrayList<Literal> newList = null;
            if (this.literalList != null) {
                newList = new ArrayList<Literal>();
                for (Literal lit : this.literalList) {
                    newList.add((Literal)lit.clone());
                }
            }
            return new MetaStatement(this.token, (Predicate)this.predicate.clone(), newList, this.startLineNo);
        }
        return new MetaStatement(this.token, this.startLineNo);
    }

    @Override
    public String toOutputString() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.id != null) {
            return String.valueOf(this.token) + " " + this.id.toString() + "/" + this.number.toString() + ".";
        }
        if (this.predicate != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.token);
            sb.append(" ");
            sb.append(this.predicate.toString());
            if (this.literalList != null && this.literalList.size() > 0) {
                int i = 0;
                while (i < this.literalList.size() - 1) {
                    sb.append(this.literalList.get(i).toString());
                    sb.append(", ");
                    ++i;
                }
                sb.append(this.literalList.get(this.literalList.size() - 1).toString());
            }
            sb.append(".");
            return sb.toString();
        }
        return String.valueOf(this.token) + ".";
    }
}

