/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.model.LineBase;
import aspmodificator.parser.gringo.Optimize;
import aspmodificator.parser.gringo.OptimizeLiteral;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class OptimizeCommand
extends LineBase {
    private List<OptimizeLiteral> literals;
    private Optimize type;

    public OptimizeCommand(Optimize sopt, List<OptimizeLiteral> list) {
        this.type = sopt;
        this.literals = list;
    }

    public OptimizeCommand(Optimize sopt, List<OptimizeLiteral> list, int startLineNo) {
        this.type = sopt;
        this.literals = list;
        this.startLineNo = startLineNo;
    }

    public OptimizeCommand(Optimize sopt, Set<OptimizeLiteral> set) {
        this.type = sopt;
        this.literals = new ArrayList<OptimizeLiteral>(set);
    }

    public OptimizeCommand(Optimize sopt, Set<OptimizeLiteral> set, int startLineNo) {
        this.type = sopt;
        this.literals = new ArrayList<OptimizeLiteral>(set);
        this.startLineNo = startLineNo;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrayList<OptimizeLiteral> tmpList = new ArrayList<OptimizeLiteral>();
        if (this.literals != null && this.literals.size() > 0) {
            for (OptimizeLiteral lit : this.literals) {
                tmpList.add((OptimizeLiteral)lit.clone());
            }
        }
        return new OptimizeCommand(this.type, tmpList, this.startLineNo);
    }

    public List<OptimizeLiteral> getLiterals() {
        return this.literals;
    }

    public Optimize getType() {
        return this.type;
    }

    public void setLiterals(List<OptimizeLiteral> literals) {
        this.literals = literals;
    }

    public void setType(Optimize type) {
        this.type = type;
    }

    @Override
    public String toOutputString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type.toString().toLowerCase());
        sb.append(" [ ");
        int currentLineNo = 0;
        OptimizeLiteral lit = null;
        if (this.literals != null) {
            currentLineNo = this.literals.get(0).getLineNo();
            int i = 0;
            while (i < this.literals.size() - 1) {
                lit = this.literals.get(i);
                while (lit.getLineNo() > currentLineNo) {
                    sb.append("\n");
                    ++currentLineNo;
                }
                sb.append(lit.toString());
                sb.append(",");
                ++i;
            }
            lit = this.literals.get(this.literals.size() - 1);
            while (lit.getLineNo() > currentLineNo) {
                sb.append("\n");
                ++currentLineNo;
            }
            sb.append(lit.toString());
        }
        sb.append(" ].");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type.toString().toLowerCase());
        sb.append(" [ ");
        if (this.literals != null) {
            int i = 0;
            while (i < this.literals.size() - 1) {
                sb.append(this.literals.get(i).toString());
                sb.append(",");
                ++i;
            }
            sb.append(this.literals.get(this.literals.size() - 1).toString());
        }
        sb.append(" ].");
        return sb.toString();
    }
}

