/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import java.util.ArrayList;
import java.util.List;

public class OptimizeLiteral {
    private Literal head;
    private Term weight;
    private Term prio;
    private List<Literal> body;
    private int lineNo = -1;

    public OptimizeLiteral(Literal head, Term weight, Term prio, List<Literal> body) {
        this.head = head;
        this.weight = weight;
        this.prio = prio;
        this.body = body;
    }

    public OptimizeLiteral(Literal head, Term weight, Term prio, List<Literal> body, int lineNo) {
        this.head = head;
        this.weight = weight;
        this.prio = prio;
        this.body = body;
        this.lineNo = lineNo;
    }

    public Object clone() throws CloneNotSupportedException {
        Literal newHead = null;
        if (this.head != null) {
            newHead = (Literal)this.head.clone();
        }
        Term newWeight = null;
        if (this.weight != null) {
            newWeight = (Term)this.weight.clone();
        }
        Term newPrio = null;
        if (this.prio != null) {
            newPrio = (Term)this.prio.clone();
        }
        ArrayList<Literal> newBody = new ArrayList<Literal>();
        if (this.body != null && this.body.size() > 0) {
            for (Literal lit : this.body) {
                newBody.add((Literal)lit.clone());
            }
        }
        return new OptimizeLiteral(newHead, newWeight, newPrio, newBody, this.lineNo);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.head != null) {
            sb.append(this.head.toString());
        }
        if (this.body != null) {
            sb.append(" : ");
            int i = 0;
            while (i < this.body.size() - 1) {
                sb.append(this.body.get(i).toString());
                sb.append(" : ");
                ++i;
            }
            sb.append(this.body.get(this.body.size() - 1).toString());
        }
        if (this.weight != null) {
            sb.append(" = ");
            sb.append(this.weight.toString());
        }
        if (this.prio != null) {
            sb.append(" @");
            sb.append(this.prio.toString());
        }
        return sb.toString();
    }
}

