/*
 * Decompiled with CFR 0.152.
 */
package aspmodificator.parser.gringo;

import aspmodificator.parser.gringo.BlockComment;
import aspmodificator.parser.gringo.Literal;
import aspmodificator.parser.gringo.Term;
import java.util.ArrayList;
import java.util.List;

public class Predicate
extends Literal {
    private boolean negated;

    protected Predicate() {
    }

    public Predicate(String id, List<Term> terms, boolean negated) {
        super(id, null, false);
        if (terms != null) {
            this.setTerms(new ArrayList<Literal>(terms));
        }
        this.negated = negated;
    }

    public Predicate(String id, List<Term> terms, boolean negated, int lineNo) {
        super(id, null, false, lineNo);
        if (terms != null) {
            this.setTerms(new ArrayList<Literal>(terms));
        }
        this.negated = negated;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Predicate p = (Predicate)super.clone();
        p.setNegated(this.negated);
        return p;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.precedingComments != null && this.precedingComments.size() > 0) {
            for (BlockComment bc : this.precedingComments) {
                sb.append(" ");
                sb.append(bc.getText());
                sb.append(" ");
            }
        }
        if (this.signed) {
            sb.append("not ");
        }
        if (this.negated) {
            sb.append("-");
        }
        if (this.identifier != null) {
            sb.append(this.identifier);
        }
        if (this.terms != null && this.terms.size() > 0) {
            sb.append("(");
            int i = 0;
            while (i < this.terms.size() - 1) {
                sb.append(((Literal)this.terms.get(i)).toString());
                sb.append(",");
                ++i;
            }
            sb.append(((Literal)this.terms.get(this.terms.size() - 1)).toString());
            sb.append(")");
        }
        if (this.succeedingComments != null && this.succeedingComments.size() > 0) {
            for (BlockComment bc : this.succeedingComments) {
                sb.append(" ");
                sb.append(bc.getText());
                sb.append(" ");
            }
        }
        return sb.toString();
    }
}

