/*
 * Decompiled with CFR 0.152.
 */
package main;

import aspmodificator.modificationrules.IModificationRule;
import aspmodificator.modificationrules.gringo.AddDefaultNegationModificationRule;
import aspmodificator.modificationrules.gringo.AddStrongNegationModificationRule;
import aspmodificator.modificationrules.gringo.AggregateLiteralModificationRule;
import aspmodificator.modificationrules.gringo.ConstantToVariableModificationRule;
import aspmodificator.modificationrules.gringo.DeleteRuleModificationRule;
import aspmodificator.modificationrules.gringo.DeleteTermModificationRule;
import aspmodificator.modificationrules.gringo.LogicRuleTypeEnum;
import aspmodificator.modificationrules.gringo.MathOperatorsModificationRule;
import aspmodificator.modificationrules.gringo.RangeTermModificationRule;
import aspmodificator.modificationrules.gringo.RelationOperatorModificationRule;
import aspmodificator.modificationrules.gringo.RemoveDefaultNegationModificationRule;
import aspmodificator.modificationrules.gringo.RemoveStrongNegationModificationRule;
import aspmodificator.modificationrules.gringo.RenamePredicateModificationRule;
import aspmodificator.modificationrules.gringo.RenameVariableModificationRule;
import aspmodificator.modificationrules.gringo.ReplaceConstantModificationRule;
import aspmodificator.modificationrules.gringo.ReplaceLiteralModificationRule;
import aspmodificator.modificationrules.gringo.RuleTargetEnum;
import aspmodificator.modificationrules.gringo.SwapStrongNegationModificationRule;
import aspmodificator.modificationrules.gringo.SwapTermModificationRule;
import aspmodificator.modificationrules.gringo.SwitchDefaultNegationModificationRule;
import aspmodificator.modificationrules.gringo.TwiddleAggregateWeightsModificationRule;
import aspmodificator.modificationrules.gringo.TwiddleMathStatementModificationRule;
import aspmodificator.modificationrules.gringo.VariableToConstantModificationRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import main.RuleApplicationEnum;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class AspModificationConfig {
    private static final String CONFIGURATIONTAG = "configuration";
    private static final String MODIFICATION_RULES_TAG = "modificationRules";
    private static final String MODIFICATION_RULE_TAG = "modificationRule";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_MIN = "min";
    private static final String ATTRIBUTE_MAX = "max";
    private static final String MR_DELETERULE_TAG = "deleteRule";
    private static final String MR_DELETELITERAL_TAG = "deleteLiteral";
    private static final String MR_RANGETERM_TAG = "changeRangeTerms";
    private static final String MR_RELATIONOPERATOR_TAG = "changeRelationOperators";
    private static final String MR_SWAPTERM_TAG = "swapTerms";
    private static final String MR_AGGREGATE_TAG = "changeAggregates";
    private static final String MR_MATHOPERATORS_TAG = "changeMathOperators";
    private static final String MR_SWAP_DEFAULT_NEGATION_TAG = "swapDefaultNegation";
    private static final String MR_SWAP_STRONG_NEGATION_TAG = "swapStrongNegation";
    private static final String ATTRIBUTE_SWAP_STRONG_NEGATION_REQUIREEXISTINGPREDICATE = "requireExistingObject";
    private static final String ATTRIBUTE_VARIABLE_TO_CONSTANT_REQUIREEXISTINGPREDICATE = "requireExistingObject";
    private static final String MR_VARIABLE_TO_CONSTANT_TAG = "changeVariableToConstant";
    private static final String MR_CONSTANT_TO_VARIABLE_TAG = "changeConstantToVariable";
    private static final String MR_REPLACE_CONSTANTS = "replaceConstants";
    private static final String MR_REPLACE_LITERALS = "replaceGroundedLiterals";
    private static final String MR_TWIDDLEMATHSTATEMENT = "twiddleMathStatement";
    private static final String MR_TWIDDLEAGGREGATEWEIGHT = "twiddleAggregateWeight";
    private static final String MR_RENAME_PREDICATE_TAG = "renamePredicates";
    private static final String MR_ADD_DEFAULT_NEGATION_TAG = "addDefaultNegation";
    private static final String MR_REMOVE_DEFAULT_NEGATION_TAG = "removeDefaultNegation";
    private static final String MR_ADD_STRONG_NEGATION_TAG = "addStrongNegation";
    private static final String MR_REMOVE_STRONG_NEGATION_TAG = "removeStrongNegation";
    private static final String CF_RULE_APPLICATION = "ruleApplication";
    private static final String CF_WRITE_COMMENTS = "writeComments";
    private static final String CF_OUTPUT_DIRECTORY = "outputDirectory";
    private static final String CF_INPUT_FILE = "inputFile";
    private static final String CF_RANDOM_INIT = "randomInit";
    private static final String CF_NO_COPIES = "noCopies";
    private static final String CF_USE_MEMORY = "useMemory";
    private static final String ATTRIBUTE_DELETELITERAL_INCLUDEINSIDELITERALS = "includeInsideLiterals";
    private static final String ATTRIBUTE_CHANGERELATIONOPERATOR_AVOIDNEARLYINEQUALOPERATORS = "avoidNearlyInequalOperators";
    private static final String ATTRIBUTE_TWIDDLEMATHSTATEMENT_INCLUDERELATIONS = "includeRelations";
    private static final String ATTRIBUTE_TWIDDLEMATHSTATEMENT_INCLUDEMATHTERMS = "includeMathTerms";
    private static final String ATTRIBUTE_MR_RULETARGET = "targetLiterals";
    private static final String MR_RDP_TAG = "RDP";
    private static final String MR_RDC_TAG = "RDC";
    private static final String MR_RDF_TAG = "RDF";
    private static final String MR_LDB_TAG = "LDB";
    private static final String MR_LDH_TAG = "LDH";
    private static final String MR_LAD_TAG = "LAD";
    private static final String MR_LRD_TAG = "LRD";
    private static final String MR_LAS_TAG = "LAS";
    private static final String MR_LRS_TAG = "LRS";
    private static final String MR_LRP_TAG = "LRP";
    private static final String MR_LRC_TAG = "LRC";
    private static final String MR_ARO_TAG = "ARO";
    private static final String MR_ATV_TAG = "ATV";
    private static final String MR_ATA_TAG = "ATA";
    private static final String MR_ATW_TAG = "ATW";
    private static final String MR_TST_TAG = "TST";
    private static final String MR_TVC_TAG = "TVC";
    private static final String MR_TRV_TAG = "TRV";
    private static final String MR_TCV_TAG = "TCV";
    private static final String MR_TRC_TAG = "TRC";
    protected File outputDir = null;
    protected File inputFile;
    protected int noCopies = 1;
    protected boolean writeComments = false;
    protected String outputFileName = null;
    protected boolean useMemory = true;
    private static Logger logger = Logger.getLogger(AspModificationConfig.class);
    private RuleApplicationEnum ruleApplication = RuleApplicationEnum.all;
    private List<IModificationRule> modificationRules;
    private long randomInit = System.currentTimeMillis();

    public static AspModificationConfig createConfigFromFile(File file) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException("Config-file not found");
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(file);
        return AspModificationConfig.createAspModificationConfigFromDoc(doc);
    }

    private static void doCommonConfiguration(Element rootElement, AspModificationConfig config) {
        List children = rootElement.getChildren();
        for (Element el : children) {
            try {
                AspModificationConfig.handleConfigElement(el, config);
            }
            catch (Exception e) {
                logger.error((Object)"Error while reading config-file", (Throwable)e);
            }
        }
    }

    private static IModificationRule generateRule(Element element) throws Exception {
        String type = element.getAttributeValue(ATTRIBUTE_TYPE);
        if (type == null || type == "") {
            return null;
        }
        int minApplication = 1;
        int maxApplication = 1;
        String min = element.getAttributeValue(ATTRIBUTE_MIN);
        if (min != null && min != "" && (minApplication = Integer.parseInt(min)) < 0) {
            throw new Exception("min-value must be greater or equal 0");
        }
        String max = element.getAttributeValue(ATTRIBUTE_MAX);
        if (max != null && max != "") {
            maxApplication = Integer.parseInt(max);
            if (maxApplication < 0) {
                throw new Exception("max-value must be greater or equal 0");
            }
            if (maxApplication < minApplication) {
                throw new Exception("max-value must be less or equal min-value");
            }
        }
        return AspModificationConfig.generateRuleByType(type, minApplication, maxApplication, element);
    }

    private static IModificationRule generateRuleByType(String type, int minApplication, int maxApplication, Element element) {
        String targetLiteralString = element.getAttributeValue(ATTRIBUTE_MR_RULETARGET);
        RuleTargetEnum targetEnum = null;
        if (targetLiteralString != null && targetLiteralString != "") {
            targetEnum = RuleTargetEnum.valueOf(targetLiteralString);
        }
        if (type.equals(MR_DELETERULE_TAG)) {
            return new DeleteRuleModificationRule(minApplication, maxApplication);
        }
        if (type.equals(MR_DELETELITERAL_TAG)) {
            String includeInsideLiteralsString = element.getAttributeValue(ATTRIBUTE_DELETELITERAL_INCLUDEINSIDELITERALS);
            boolean includeInsideLiterals = false;
            if (includeInsideLiteralsString != null && includeInsideLiteralsString != "") {
                includeInsideLiterals = Boolean.parseBoolean(includeInsideLiteralsString);
            }
            DeleteTermModificationRule tmpRule = new DeleteTermModificationRule(minApplication, maxApplication);
            tmpRule.setIncludeInsideLiterals(includeInsideLiterals);
            if (targetEnum != null) {
                tmpRule.setMrRuleTarget(targetEnum);
            }
            return tmpRule;
        }
        if (type.equals(MR_RANGETERM_TAG)) {
            RangeTermModificationRule rule = new RangeTermModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_RELATIONOPERATOR_TAG)) {
            String avoidNearlyInequalOperatorsString = element.getAttributeValue(ATTRIBUTE_CHANGERELATIONOPERATOR_AVOIDNEARLYINEQUALOPERATORS);
            boolean avoidNearlyInequalOperators = false;
            if (avoidNearlyInequalOperatorsString != null && avoidNearlyInequalOperatorsString != "") {
                avoidNearlyInequalOperators = Boolean.parseBoolean(avoidNearlyInequalOperatorsString);
            }
            RelationOperatorModificationRule rule = new RelationOperatorModificationRule(minApplication, maxApplication, avoidNearlyInequalOperators);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_SWAPTERM_TAG)) {
            SwapTermModificationRule rule = new SwapTermModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_AGGREGATE_TAG)) {
            AggregateLiteralModificationRule rule = new AggregateLiteralModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_MATHOPERATORS_TAG)) {
            return new MathOperatorsModificationRule(minApplication, maxApplication);
        }
        if (type.equals(MR_SWAP_DEFAULT_NEGATION_TAG)) {
            return new SwitchDefaultNegationModificationRule(minApplication, maxApplication);
        }
        if (type.equals(MR_SWAP_STRONG_NEGATION_TAG)) {
            String requireExistingPredicateString = element.getAttributeValue("requireExistingObject");
            boolean requireExistingPredicate = false;
            if (requireExistingPredicateString != null && requireExistingPredicateString != "") {
                requireExistingPredicate = Boolean.parseBoolean(requireExistingPredicateString);
            }
            SwapStrongNegationModificationRule rule = new SwapStrongNegationModificationRule(minApplication, maxApplication, requireExistingPredicate);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_VARIABLE_TO_CONSTANT_TAG)) {
            String requireExistingConstantString = element.getAttributeValue("requireExistingObject");
            RuleTargetEnum requireExistingEnum = RuleTargetEnum.NONE;
            if (requireExistingConstantString != null && requireExistingConstantString != "") {
                requireExistingEnum = RuleTargetEnum.valueOf(requireExistingConstantString);
            }
            VariableToConstantModificationRule rule = new VariableToConstantModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            rule.setExistenceCheckTarget(requireExistingEnum);
            return rule;
        }
        if (type.equals(MR_CONSTANT_TO_VARIABLE_TAG)) {
            ConstantToVariableModificationRule rule = new ConstantToVariableModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_RENAME_PREDICATE_TAG)) {
            RenamePredicateModificationRule rule = new RenamePredicateModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_REPLACE_CONSTANTS)) {
            ReplaceConstantModificationRule rule = new ReplaceConstantModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_REPLACE_LITERALS)) {
            ReplaceLiteralModificationRule rule = new ReplaceLiteralModificationRule(minApplication, maxApplication);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_ADD_DEFAULT_NEGATION_TAG)) {
            return new AddDefaultNegationModificationRule(minApplication, maxApplication);
        }
        if (type.equals(MR_REMOVE_DEFAULT_NEGATION_TAG)) {
            return new RemoveDefaultNegationModificationRule(minApplication, maxApplication);
        }
        if (type.equals(MR_ADD_STRONG_NEGATION_TAG)) {
            String requireExistingPredicateString = element.getAttributeValue("requireExistingObject");
            boolean requireExistingPredicate = false;
            if (requireExistingPredicateString != null && requireExistingPredicateString != "") {
                requireExistingPredicate = Boolean.parseBoolean(requireExistingPredicateString);
            }
            AddStrongNegationModificationRule rule = new AddStrongNegationModificationRule(minApplication, maxApplication, requireExistingPredicate);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_REMOVE_STRONG_NEGATION_TAG)) {
            String requireExistingPredicateString = element.getAttributeValue("requireExistingObject");
            boolean requireExistingPredicate = false;
            if (requireExistingPredicateString != null && requireExistingPredicateString != "") {
                requireExistingPredicate = Boolean.parseBoolean(requireExistingPredicateString);
            }
            RemoveStrongNegationModificationRule rule = new RemoveStrongNegationModificationRule(minApplication, maxApplication, requireExistingPredicate);
            if (targetEnum != null) {
                rule.setMrRuleTarget(targetEnum);
            }
            return rule;
        }
        if (type.equals(MR_TWIDDLEMATHSTATEMENT)) {
            String includeRelationsString = element.getAttributeValue(ATTRIBUTE_TWIDDLEMATHSTATEMENT_INCLUDERELATIONS);
            boolean includeRelations = true;
            if (includeRelationsString != null && includeRelationsString != "") {
                includeRelations = Boolean.parseBoolean(includeRelationsString);
            }
            String includeMathTermsString = element.getAttributeValue(ATTRIBUTE_TWIDDLEMATHSTATEMENT_INCLUDEMATHTERMS);
            boolean includeMathTerms = true;
            if (includeMathTermsString != null && includeMathTermsString != "") {
                includeMathTerms = Boolean.parseBoolean(includeMathTermsString);
            }
            return new TwiddleMathStatementModificationRule(minApplication, maxApplication, includeRelations, includeMathTerms);
        }
        if (type.equals(MR_TWIDDLEAGGREGATEWEIGHT)) {
            TwiddleAggregateWeightsModificationRule rule = new TwiddleAggregateWeightsModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_RDP_TAG)) {
            DeleteRuleModificationRule rule = new DeleteRuleModificationRule(minApplication, maxApplication);
            rule.setRuleType(LogicRuleTypeEnum.PROPER);
            return rule;
        }
        if (type.equals(MR_RDC_TAG)) {
            DeleteRuleModificationRule rule = new DeleteRuleModificationRule(minApplication, maxApplication);
            rule.setRuleType(LogicRuleTypeEnum.CONSTRAINT);
            return rule;
        }
        if (type.equals(MR_RDF_TAG)) {
            DeleteRuleModificationRule rule = new DeleteRuleModificationRule(minApplication, maxApplication);
            rule.setRuleType(LogicRuleTypeEnum.FACT);
            return rule;
        }
        if (type.equals(MR_LDB_TAG)) {
            DeleteTermModificationRule rule = new DeleteTermModificationRule(minApplication, maxApplication);
            rule.setMrRuleTarget(RuleTargetEnum.BODY);
            return rule;
        }
        if (type.equals(MR_LDH_TAG)) {
            DeleteTermModificationRule rule = new DeleteTermModificationRule(minApplication, maxApplication);
            rule.setMrRuleTarget(RuleTargetEnum.HEAD);
            return rule;
        }
        if (type.equals(MR_LAD_TAG)) {
            AddDefaultNegationModificationRule rule = new AddDefaultNegationModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_LRD_TAG)) {
            RemoveStrongNegationModificationRule rule = new RemoveStrongNegationModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_LAS_TAG)) {
            AddStrongNegationModificationRule rule = new AddStrongNegationModificationRule(minApplication, maxApplication);
            rule.setRequireExistingObject(true);
            return rule;
        }
        if (type.equals(MR_LRS_TAG)) {
            RemoveStrongNegationModificationRule rule = new RemoveStrongNegationModificationRule(minApplication, maxApplication);
            rule.setRequireExistingObject(true);
            return rule;
        }
        if (type.equals(MR_LRP_TAG)) {
            RenamePredicateModificationRule rule = new RenamePredicateModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_LRC_TAG)) {
            ReplaceConstantModificationRule rule = new ReplaceConstantModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_ARO_TAG)) {
            MathOperatorsModificationRule rule = new MathOperatorsModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_ATV_TAG)) {
            TwiddleMathStatementModificationRule rule = new TwiddleMathStatementModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_ATA_TAG)) {
            AggregateLiteralModificationRule rule = new AggregateLiteralModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_ATW_TAG)) {
            TwiddleAggregateWeightsModificationRule rule = new TwiddleAggregateWeightsModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_TST_TAG)) {
            SwapTermModificationRule rule = new SwapTermModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_TVC_TAG)) {
            VariableToConstantModificationRule rule = new VariableToConstantModificationRule(minApplication, maxApplication);
            rule.setExistenceCheckTarget(RuleTargetEnum.ALL);
            return rule;
        }
        if (type.equals(MR_TRV_TAG)) {
            RenameVariableModificationRule rule = new RenameVariableModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_TCV_TAG)) {
            ConstantToVariableModificationRule rule = new ConstantToVariableModificationRule(minApplication, maxApplication);
            return rule;
        }
        if (type.equals(MR_TRC_TAG)) {
            ReplaceConstantModificationRule rule = new ReplaceConstantModificationRule(minApplication, maxApplication);
            return rule;
        }
        logger.warn((Object)("Unknown rule-tag: " + type));
        return null;
    }

    private static void handleConfigElement(Element el, AspModificationConfig config) {
        String name = el.getName();
        if (name.equals(CF_RULE_APPLICATION)) {
            String value = el.getAttributeValue("application");
            if (value != null) {
                config.setRuleApplication(RuleApplicationEnum.valueOf(value));
            } else {
                logger.warn((Object)"ruleApplication tag without value found");
            }
            return;
        }
        if (name.equals(CF_WRITE_COMMENTS)) {
            String value = el.getAttributeValue("value");
            if (value != null) {
                config.setWriteComments(Boolean.parseBoolean(value));
            } else {
                logger.warn((Object)"writeComments tag without value found");
            }
            return;
        }
        if (name.equals(CF_OUTPUT_DIRECTORY)) {
            File tmpFile;
            String value = el.getAttributeValue("value");
            if (value == null) {
                logger.warn((Object)"outputDirectory tag without value found");
            }
            if (!(tmpFile = new File(value)).isDirectory()) {
                logger.warn((Object)"Outputpath in logfile is not an existing directory");
                return;
            }
            config.setOutputDir(tmpFile);
            return;
        }
        if (name.equals(CF_INPUT_FILE)) {
            File tmpFile;
            String value = el.getAttributeValue("value");
            if (value == null || value == "") {
                logger.warn((Object)"inputFile tag without value found");
            }
            if (!(tmpFile = new File(value)).exists() || tmpFile.isDirectory()) {
                System.out.println(String.valueOf(value) + " does not exist or is a directory");
            }
            config.setInputFile(tmpFile);
            return;
        }
        if (name.equals(CF_RANDOM_INIT)) {
            String value = el.getAttributeValue("value");
            if (value == null || value == "") {
                logger.warn((Object)"randomInit tag without value found");
            }
            config.setRandomInit(Long.parseLong(value));
            return;
        }
        if (name.equals(CF_NO_COPIES)) {
            String value = el.getAttributeValue("value");
            if (value == null || value == "") {
                logger.warn((Object)"noCopies tag without value found");
            }
            config.setNoCopies(Integer.parseInt(value));
            return;
        }
        if (name.equals(CF_USE_MEMORY)) {
            String value = el.getAttributeValue("value");
            if (value != null) {
                config.setUseMemory(Boolean.parseBoolean(value));
            } else {
                logger.warn((Object)"useMemory tag without value found");
            }
            return;
        }
        logger.warn((Object)("Unknown config-element: " + name));
    }

    private static void setModificationRules(Element modRules, AspModificationConfig config) throws Exception {
        List rules = modRules.getChildren(MODIFICATION_RULE_TAG);
        if (rules == null || rules.size() == 0) {
            throw new Exception("No modification rules found in config-file");
        }
        ArrayList<IModificationRule> ruleList = new ArrayList<IModificationRule>();
        for (Element element : rules) {
            IModificationRule rule = AspModificationConfig.generateRule(element);
            if (rule == null) continue;
            ruleList.add(rule);
        }
        config.setModificationRules(ruleList);
    }

    protected static AspModificationConfig createAspModificationConfigFromDoc(Document doc) throws Exception {
        Element modRules;
        AspModificationConfig config = new AspModificationConfig();
        Element root = doc.getRootElement();
        Element configuration = root.getChild(CONFIGURATIONTAG);
        if (configuration != null) {
            AspModificationConfig.doCommonConfiguration(configuration, config);
        }
        if ((modRules = root.getChild(MODIFICATION_RULES_TAG)) == null) {
            throw new Exception("No element with <modificationRules> found!");
        }
        AspModificationConfig.setModificationRules(modRules, config);
        return config;
    }

    public static AspModificationConfig createConfigFromFile(String filePath) throws Exception {
        if (filePath == null) {
            throw new NullPointerException("Path to config-file must not be null");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Config-file not found");
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(file);
        return AspModificationConfig.createAspModificationConfigFromDoc(doc);
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public List<IModificationRule> getModificationRules() {
        return this.modificationRules;
    }

    public int getNoCopies() {
        return this.noCopies;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public long getRandomInit() {
        return this.randomInit;
    }

    public RuleApplicationEnum getRuleApplication() {
        return this.ruleApplication;
    }

    public boolean isUseMemory() {
        return this.useMemory;
    }

    public boolean isWriteComments() {
        return this.writeComments;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setModificationRules(List<IModificationRule> modificationRules) {
        this.modificationRules = modificationRules;
    }

    public void setNoCopies(int noCopies) {
        this.noCopies = noCopies;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setRandomInit(long randomInit) {
        this.randomInit = randomInit;
    }

    private void setRuleApplication(RuleApplicationEnum ruleApplication) {
        this.ruleApplication = ruleApplication;
    }

    public void setUseMemory(boolean useMemory) {
        this.useMemory = useMemory;
    }

    public void setWriteComments(boolean writeComments) {
        this.writeComments = writeComments;
    }
}

