/*
 * Decompiled with CFR 0.152.
 */
package main;

import aspmodificator.base.ProgramModificator;
import aspmodificator.model.LineBase;
import aspmodificator.parser.GringoParser;
import aspmodificator.parser.IFileParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import main.AspModificationConfig;
import org.apache.log4j.Logger;

public class AspModificator {
    private static Logger logger = Logger.getLogger(AspModificator.class);
    private ProgramModificator programModificator = new ProgramModificator();
    private AspModificationConfig config;
    private IFileParser parser = new GringoParser();

    public void doYourJob() throws Exception {
        this.programModificator.setWriteComments(this.config.isWriteComments());
        this.programModificator.setRandomInitialization(this.config.getRandomInit());
        this.programModificator.setRuleApplication(this.config.getRuleApplication());
        this.programModificator.setUseMemory(this.config.isUseMemory());
        if (this.config.getInputFile() == null || this.config.getInputFile().isDirectory() || !this.config.getInputFile().exists()) {
            throw new Exception("Invalid input-file");
        }
        if (this.config.getOutputDir() == null) {
            this.config.setOutputDir(new File("."));
        }
        if (this.config.getOutputFileName() == null) {
            this.config.setOutputFileName(String.valueOf(this.config.getInputFile().getName().substring(0, this.config.getInputFile().getName().lastIndexOf("."))) + "_mod" + this.config.getInputFile().getName().substring(this.config.getInputFile().getName().lastIndexOf(".")));
        }
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(this.config.getInputFile()));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        List<LineBase> program = this.parser.parse(fileData.toString());
        int noZeros = (int)Math.log10(this.config.getNoCopies()) + 1;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < noZeros) {
            sb.append("0");
            ++i;
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        int i2 = 0;
        while (i2 < this.config.getNoCopies()) {
            List<LineBase> modifiedProgram = this.programModificator.modifyProgram(program, this.config.getModificationRules());
            if (modifiedProgram == null) {
                logger.info((Object)("Unable to create additional mutants - only " + i2 + " of " + this.config.getNoCopies() + " mutants created."));
                return;
            }
            String newName = String.valueOf(this.config.getOutputFileName().substring(0, this.config.getOutputFileName().lastIndexOf("."))) + df.format(i2) + this.config.getOutputFileName().substring(this.config.getOutputFileName().lastIndexOf("."));
            this.writeProgramToFile(modifiedProgram, new File(String.valueOf(this.config.getOutputDir().toString()) + File.separator + newName));
            ++i2;
        }
    }

    public void setConfig(AspModificationConfig config) {
        this.config = config;
    }

    public void setInputFile(File inputFile) {
        this.config.setInputFile(inputFile);
    }

    public void setNoCopies(int value) {
        this.config.setNoCopies(value);
    }

    public void setOutputDir(File outputDir) {
        this.config.setOutputDir(outputDir);
    }

    public void setRandomInitialization(long seed) {
        this.config.setRandomInit(seed);
    }

    public void setWriteComments(boolean writeComments) {
        this.config.setWriteComments(writeComments);
    }

    private void writeProgramToFile(List<LineBase> modifiedProgram, File file) throws IOException {
        FileWriter out = new FileWriter(file);
        int outputLineNo = 1;
        int originalLineNo = 1;
        for (LineBase currentLine : modifiedProgram) {
            originalLineNo = currentLine.getStartLineNo();
            while (originalLineNo > outputLineNo) {
                out.write(10);
                ++outputLineNo;
            }
            String tmpString = currentLine.toOutputString();
            out.write(tmpString);
            int noNewLine = tmpString.replaceAll("[^\n]", "").length();
            outputLineNo += noNewLine;
        }
        out.close();
    }
}

