/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.OutputStream;
import main.AspModificationConfig;
import main.AspModificator;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main {
    private static Logger logger = Logger.getLogger(Main.class);
    @Option(name="-r", aliases={"-randomInit"}, usage="initialization-seed for the random-number generator")
    private Long randomInitValue = null;
    @Option(name="-noComments", usage="initialization-seed for the random-number generator")
    private Boolean writeComments = true;
    @Option(name="-o", aliases={"-out", "-outputDir"}, usage="the directory where the modified programs should be saved")
    private File outputDir = null;
    @Option(name="-c", aliases={"-configFile"}, required=true, usage="path to the config file")
    private File configFile = null;
    @Option(name="-i", aliases={"-input", "-inputFile"}, usage="file containing an asp-program which should be the base program for the modification")
    private File inputFile = null;
    @Option(name="-noCopies", usage="number of modified output-programs")
    private Integer noCopies = null;
    @Option(name="-logging", aliases={"-log"}, usage="logging options - one of the following logging-levels: \"all\", \"debug\", \"error\", \"fatal\", \"info\", \"off\", \"trace\", \"warn")
    private String loggingLevel = Level.INFO.toString();

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Main main = new Main();
        CmdLineParser parser = new CmdLineParser((Object)main);
        parser.setUsageWidth(80);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            System.exit(1);
        }
        try {
            main.run();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void run() throws Exception {
        logger.setLevel(Level.toLevel((String)this.loggingLevel));
        AspModificationConfig config = null;
        config = AspModificationConfig.createConfigFromFile(this.configFile);
        AspModificator aspModificator = new AspModificator();
        aspModificator.setConfig(config);
        if (this.randomInitValue != null) {
            aspModificator.setRandomInitialization(this.randomInitValue);
        }
        if (this.writeComments != null) {
            aspModificator.setWriteComments(this.writeComments);
        }
        if (this.noCopies != null) {
            aspModificator.setNoCopies(this.noCopies);
        }
        if (this.outputDir != null) {
            aspModificator.setOutputDir(this.outputDir);
        }
        if (this.inputFile != null) {
            aspModificator.setInputFile(this.inputFile);
        }
        if (this.outputDir != null && !this.outputDir.isDirectory()) {
            System.out.println("output path must be an existing directory");
            System.exit(1);
        }
        if (this.inputFile != null && (!this.inputFile.exists() || this.inputFile.isDirectory())) {
            System.out.println(String.valueOf(this.inputFile.getAbsolutePath()) + " does not exist or is a directory");
            System.exit(1);
        }
        try {
            aspModificator.doYourJob();
        }
        catch (Exception e) {
            logger.error((Object)"Error while working", (Throwable)e);
            e.printStackTrace();
        }
    }
}

